function [Dunit_base,Mhits_base]=som_bases(sMap,sD_selected,ID)

% Clustering of SOM based on the distance matrix between neighbors is utilized to 
% quantitatively post-process SOM.

% Return two outputs

% For Dunit_base, 1st column:           Original order of input data (sD.data);
%                 2nd column:           Best Matching Unit belonging to;
%                 3rd column:           Base belonging to; 
%                 4th to last columns:  Original input data.

% For Mhits_base, 1st column:           Neuron ID;
%                 2nd column:           Hit histogram;
%                 3rd column:           Seed flag, 1 for Yes,0 for No;
%                 4th column:           Base;
%                 5th to last columns:  Codebook matrix.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Calculate Unified distance matrix of self-organizing map.The resulting matrix holds 
% distances between neighboring map units,as well as the median distance from each map 
% unit to its neighbors.
U = som_umat(sMap);
Um = U(1:2:size(U,1),1:2:size(U,2));% median Distance matrix extracted from U-matrix

% Visualization of a SOM grid
% Each dot represents one map unit(neuron) and is connected to its neighbors with lines,
% forming SOM grid.
scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(3)*1/20 scrsz(3)*1/20 scrsz(3)*7/10*(0.815/0.775) scrsz(3)*7/10])
set(gcf,'paperpositionmode','auto','color','w')
som_grid(sMap,'MarkerSize',6,'Linecolor',[0.8 0.8 0.8],'LabelColor','w','LabelSize',4);
set(gca,'YDir','rev','visible','off')

% Visualization of median Distance matrix with map unit size
% The cluster structure of the SOM is visualized by Distance matrix. And the size of 
% map unit is inversely proportional to its average distance to its neighbors.
scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(3)*1/20 scrsz(3)*1/20 scrsz(3)*7/10*(0.815/0.775) scrsz(3)*7/10])
set(gcf,'paperpositionmode','auto','color','w')
som_cplane(sMap,'k',1-Um(:)/max(Um(:)))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Since the point density of the map prototypes roughly follows the probability density
% function of the data, distances between neighboring map units are inversely proportional
% to the density of teh data, and thus distance matrix can be utilized to cluster SOM.

% Distance matrix based clustering of the SOM
%% seed: indeces of seed units (or local minima of the distance matrix Um)
%% base: indeces of base clusters obtained using region growing (starting with seed)
[base,seed] = som_dmatclusters(sMap);

output_seed=ismember((1:size(sMap.codebook,1))',seed);% 1 denotes seed, otherwise 0
lseed=cell(size(sMap.codebook,1),1);
lseed(output_seed)=num2cell(base(output_seed));% function as seed label

% cmap retrieves the current colormap with values lying in the interval [0 1]
cmap=colormap(hsv(size(seed,2)));
% generate a ramdom permutation of cmap to fill the nearby bases with distinctive colors
cmap=cmap(randperm(size(seed,2)),:);
% define fixed unit colors using cmap for each unit (RGB triples as rows)
color_code=ones(size(sMap.codebook,1),3);
for j=1:size(seed,2)
    tmp_neurons=ismember(base,j);
    color_code(tmp_neurons,:)=repmat(cmap(j,:),sum(tmp_neurons),1);
end

% visulalization of base clusters by som
scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(3)*1/20 scrsz(3)*1/20 scrsz(3)*7/10*(0.815/0.775) scrsz(3)*7/10])
set(gcf,'paperpositionmode','auto','color','w')
som_show(sMap,'edge','on','color',{color_code,[num2str(length(seed)),' Base Clusters']})
som_show_add('label',lseed,'Text','on','TextColor',[0 0 0],'Textsize',10);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Divide input original data sD according to sMap
%% vneurons: data vectors hitting the specified neurons
%% ind: corresponding data row indexes
[vneurons,ind]=som_divide(sMap,sD_selected);

% Obtain Dunit_base
output_unit=[];
for j=1:length(ind)
    tmp_unit=repmat(j,size(ind{j},1),1);
    output_unit=[output_unit;tmp_unit];
end
for i=1:size(sD_selected.data,1)
    output_base(i,1)=base(output_unit(i),1);    
end
output_index=cell2mat(ind);
output_data=cell2mat(vneurons);
Dunit_base=[output_index output_unit output_base output_data];
Dunit_base=sortrows(Dunit_base,1);
Dunit_base=[ID Dunit_base(:,2:end)];

% Obtain Mhits_base
Mhits_base=zeros(size(sMap.codebook,1),size(sMap.codebook,2)+4);
for j=1:length(ind)
    Mhits_base(j,1)=j;
    Mhits_base(j,2)=size(ind{j},1);
end
Mhits_base(:,3)=output_seed;
Mhits_base(:,4)=base;
Mhits_base(:,5:end)=sMap.codebook;

return
